@extends($activeTemplate.'layouts.app')
@section('panel')
<script src="https://cdn.tailwindcss.com"></script>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
<style>
* {
  font-family: Kanit,cursive;
  -webkit-touch-callout: none;
  -webkit-user-select: none;
  -moz-user-select: none;
  user-select: none;
  box-sizing: border-box;
  padding: 0;
  margin: 0;
}
              #nprogress {
                  pointer-events: none;
              }

              #nprogress .bar {
                  background: #B72B41;
                  position: fixed;
                  z-index: 9999;
                  top: 0;
                  left: 0;
                  width: 100%;
                  height: 3px;
              }

              #nprogress .peg {
                  display: block;
                  position: absolute;
                  right: 0px;
                  width: 100px;
                  height: 100%;
                  box-shadow: 0 0 10px #B72B41, 0 0 5px #B72B41;
                  opacity: 1;
                  -webkit-transform: rotate(3deg) translate(0px, -4px);
                  -ms-transform: rotate(3deg) translate(0px, -4px);
                  transform: rotate(3deg) translate(0px, -4px);
              }

              #nprogress .spinner {
                  display: block;
                  position: fixed;
                  z-index: 1031;
                  top: 15px;
                  right: 15px;
              }

              #nprogress .spinner-icon {
                  width: 18px;
                  height: 18px;
                  box-sizing: border-box;
                  border: solid 2px transparent;
                  border-top-color: #B72B41;
                  border-left-color: #B72B41;
                  border-radius: 50%;
                  -webkit-animation: nprogresss-spinner 400ms linear infinite;
                  animation: nprogress-spinner 400ms linear infinite;
              }

              .nprogress-custom-parent {
                  overflow: hidden;
                  position: relative;
              }

              .nprogress-custom-parent #nprogress .spinner, .nprogress-custom-parent #nprogress .bar {
                  position: absolute;
              }

              @-webkit-keyframes nprogress-spinner {
                  0% {
                      -webkit-transform: rotate(0deg);
                  }

                  100% {
                      -webkit-transform: rotate(360deg);
                  }
              }

              @keyframes  nprogress-spinner {
                  0% {
                      transform: rotate(0deg);
                  }

                  100% {
                      transform: rotate(360deg);
                  }
              }
          </style>

<div class="min-h-screen bg-[#ebebeb] pb-10">
    <a href="{{route('user.home')}}" class="h-14 w-full bg-[#00f5bc] pl-4  gap-5 shadow text-white flex items-center ">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" class="h-7 font-bold cursor-pointer w-7">
            <path fill-rule="evenodd" d="M7.72 12.53a.75.75 0 010-1.06l7.5-7.5a.75.75 0 111.06 1.06L9.31 12l6.97 6.97a.75.75 0 11-1.06 1.06l-7.5-7.5z" clip-rule="evenodd"></path>
        </svg>
        <h2 class="text-xl text-white font-bold">Withdraw </h2>
    </a>
    <div class="flex justify-center m-5 p-4 bg-white rounded-lg py-5 shadow text-center hind">নোটিশ: মিনিমাম উইথড্র 500
       টাকা। উইথড্র দেয়ার সাথে সাথে অটোম্যাটিকভাবে পেমেন্ট পেয়ে যাবেন।</div>
    <div class="flex gap-3 items-center justify-center m-5 p-4 bg-white rounded-lg py-5 shadow">
        <h2 class=" text-xl">Balance:</h2>
        <h2 class=" text-[#ff0000] text-xl font-bold">{{showAmount(auth()->user()->balance)}} Taka</h2>
    </div>
    <form action="{{route('user.withdraw.money')}}" method="post">
       @csrf
        <input type="hidden" name="method_code" class="edit-method-code  form-control" value="">
        <div class="flex flex-col items-center justify-center m-5 p-4 bg-white rounded-lg py-5 shadow">
            <h2 class="mb-3 text-lg">Select Payment Method</h2>
            <select class="form-select form--select" name="method_code" required>
                <option value="">@lang('Select Gateway')</option>
                @foreach($withdrawMethod as $data)
                    <option value="{{ $data->id }}" data-resource="{{$data}}">  {{__($data->name)}}</option>
                @endforeach
            </select>
        </div>
        <div class="flex flex-col justify-center m-5 p-4 bg-white rounded-lg py-5 shadow">
            <h2 class="mb-3  text-xl ">Number</h2>
            <div class="flex w-full max-w-lg items-center border justify-center border-gray-300 rounded-lg overflow-hidden">
                <div class="h-12 w-12 flex items-center justify-center border-r border-gray-300">
                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="h-8 cursor-pointer w-6 text-gray-900" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                        <path d="M493.4 24.6l-104-24c-11.3-2.6-22.9 3.3-27.5 13.9l-48 112c-4.2 9.8-1.4 21.3 6.9 28l60.6 49.6c-36 76.7-98.9 140.5-177.2 177.2l-49.6-60.6c-6.8-8.3-18.2-11.1-28-6.9l-112 48C3.9 366.5-2 378.1.6 389.4l24 104C27.1 504.2 36.7 512 48 512c256.1 0 464-207.5 464-464 0-11.2-7.7-20.9-18.6-23.4z"></path>
                    </svg>
                </div>
                <div class="relative w-full min-w-[200px] h-11">
                    <input name="number" placeholder="Enter number" type="number" class="peer w-full h-full bg-transparent text-blue-gray-700 font-sans font-normal outline outline-0 focus:outline-0 disabled:bg-blue-gray-50 disabled:border-0 transition-all placeholder-shown:border placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200 border focus:border-2 border-t-transparent focus:border-t-transparent text-sm px-3 py-3 rounded-md border-blue-gray-200 focus:border-green-500 !border !border-gray-300 focus:border-none border-none bg-white text-gray-900  placeholder:text-gray-500 focus:!border-gray-900 focus:!border-t-gray-900 " value="">
                    <label class="flex w-full h-full select-none pointer-events-none absolute left-0 font-normal peer-placeholder-shown:text-blue-gray-500 leading-tight peer-focus:leading-tight peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500 transition-all -top-1.5 peer-placeholder-shown:text-sm text-[11px] peer-focus:text-[11px] before:content[' '] before:block before:box-border before:w-2.5 before:h-1.5 before:mt-[6.5px] before:mr-1 peer-placeholder-shown:before:border-transparent before:rounded-tl-md before:border-t peer-focus:before:border-t-2 before:border-l peer-focus:before:border-l-2 before:pointer-events-none before:transition-all peer-disabled:before:border-transparent after:content[' '] after:block after:flex-grow after:box-border after:w-2.5 after:h-1.5 after:mt-[6.5px] after:ml-1 peer-placeholder-shown:after:border-transparent after:rounded-tr-md after:border-t peer-focus:after:border-t-2 after:border-r peer-focus:after:border-r-2 after:pointer-events-none after:transition-all peer-disabled:after:border-transparent peer-placeholder-shown:leading-[4.1] text-blue-gray-400 peer-focus:text-green-500 before:border-blue-gray-200 peer-focus:before:!border-green-500 after:border-blue-gray-200 peer-focus:after:!border-green-500 hidden"></label>
                </div>
            </div>
            <h2 class="my-3  text-xl ">Amount</h2>
            <div class="flex w-full max-w-lg items-center border justify-center border-gray-300 rounded-lg overflow-hidden">
                <div class="h-12 w-12 flex items-center justify-center border-r border-gray-300">
                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 640 512" class="h-8 cursor-pointer w-6 text-gray-900" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                        <path d="M320 144c-53.02 0-96 50.14-96 112 0 61.85 42.98 112 96 112 53 0 96-50.13 96-112 0-61.86-42.98-112-96-112zm40 168c0 4.42-3.58 8-8 8h-64c-4.42 0-8-3.58-8-8v-16c0-4.42 3.58-8 8-8h16v-55.44l-.47.31a7.992 7.992 0 0 1-11.09-2.22l-8.88-13.31a7.992 7.992 0 0 1 2.22-11.09l15.33-10.22a23.99 23.99 0 0 1 13.31-4.03H328c4.42 0 8 3.58 8 8v88h16c4.42 0 8 3.58 8 8v16zM608 64H32C14.33 64 0 78.33 0 96v320c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32zm-16 272c-35.35 0-64 28.65-64 64H112c0-35.35-28.65-64-64-64V176c35.35 0 64-28.65 64-64h416c0 35.35 28.65 64 64 64v160z"></path>
                    </svg>
                </div>
                <div class="relative w-full min-w-[200px] h-11">
                    <input placeholder="Enter amount" name="amount" type="number" class="peer w-full h-full bg-transparent text-blue-gray-700 font-sans font-normal outline outline-0 focus:outline-0 disabled:bg-blue-gray-50 disabled:border-0 transition-all placeholder-shown:border placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200 border focus:border-2 border-t-transparent focus:border-t-transparent text-sm px-3 py-3 rounded-md border-blue-gray-200 focus:border-green-500 !border !border-gray-300 focus:border-none border-none bg-white text-gray-900  placeholder:text-gray-500 focus:!border-gray-900 focus:!border-t-gray-900 " value="">
                    <label class="flex w-full h-full select-none pointer-events-none absolute left-0 font-normal peer-placeholder-shown:text-blue-gray-500 leading-tight peer-focus:leading-tight peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500 transition-all -top-1.5 peer-placeholder-shown:text-sm text-[11px] peer-focus:text-[11px] before:content[' '] before:block before:box-border before:w-2.5 before:h-1.5 before:mt-[6.5px] before:mr-1 peer-placeholder-shown:before:border-transparent before:rounded-tl-md before:border-t peer-focus:before:border-t-2 before:border-l peer-focus:before:border-l-2 before:pointer-events-none before:transition-all peer-disabled:before:border-transparent after:content[' '] after:block after:flex-grow after:box-border after:w-2.5 after:h-1.5 after:mt-[6.5px] after:ml-1 peer-placeholder-shown:after:border-transparent after:rounded-tr-md after:border-t peer-focus:after:border-t-2 after:border-r peer-focus:after:border-r-2 after:pointer-events-none after:transition-all peer-disabled:after:border-transparent peer-placeholder-shown:leading-[4.1] text-blue-gray-400 peer-focus:text-green-500 before:border-blue-gray-200 peer-focus:before:!border-green-500 after:border-blue-gray-200 peer-focus:after:!border-green-500 hidden"></label>
                </div>
            </div>
            <p class="text-red-500 text-sm text-left w-full mt-1">Minimum withdraw 500 BDT</p>
        </div>


        <div class="m-5">
            <button type="submit" class="align-middle select-none font-sans font-bold text-center uppercase transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none text-xs py-3 px-6 text-white shadow-blue-500/20 hover:shadow-lg hover:shadow-blue-500/40 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none w-full hover:bg-[#00f5bc] mt-6 bg-[#00f5bc] shadow-none flex gap-3 justify-center items-center rounded-full">Withdraw</button>
        </div>
    </form>
</div>
<div style="display:none; justify-content:center; align-items:center;">
    <span class="balance-text">Total Withdraw: 0 Taka</span>
</div>
<div class="row" style="display:none">
    <div class="col-md-12 mb-30" style="display:none"></div>
    <div class="card-4">
        <a href="javascript:void(0)" data-id="1" data-resource="{&quot;id&quot;:1,&quot;name&quot;:&quot;Nagad&quot;,&quot;image&quot;:&quot;664c6f62125c41716285282.png&quot;,&quot;min_limit&quot;:&quot;500.00000000&quot;,&quot;max_limit&quot;:&quot;25000.00000000&quot;,&quot;delay&quot;:&quot;Auto System&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;currency&quot;:&quot;Taka&quot;,&quot;user_data&quot;:{&quot;\u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0\u099f\u09be_\u098f\u0996\u09be\u09a8\u09c7_\u09a6\u09bf\u09a8&quot;:{&quot;field_name&quot;:&quot;\u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0\u099f\u09be_\u098f\u0996\u09be\u09a8\u09c7_\u09a6\u09bf\u09a8&quot;,&quot;field_level&quot;:&quot;\u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0\u099f\u09be \u098f\u0996\u09be\u09a8\u09c7 \u09a6\u09bf\u09a8&quot;,&quot;type&quot;:&quot;text&quot;,&quot;validation&quot;:&quot;required&quot;}},&quot;description&quot;:&quot;\u0986\u09aa\u09a8\u09bf \u09af\u09c7\u0987 \u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0\u09c7 \u099f\u09be\u0995\u09be \u09a8\u09bf\u09ac\u09c7\u09a8 \u09ab\u09be\u0995\u09be \u09ac\u0995\u09cd\u09b8\u09c7&amp;nbsp; \u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0\u099f\u09bf \u09ac\u09b8\u09be\u09af\u09bc, CONFIRM \u098f \u0995\u09cd\u09b2\u09bf\u0995 \u0995\u09b0\u09c1\u09a8&amp;nbsp;&quot;,&quot;status&quot;:1,&quot;created_at&quot;:&quot;2022-11-10T07:34:52.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-05-21T09:54:42.000000Z&quot;}" class="btn btn-block  cmn-btn deposit" data-toggle="modal" data-target="#exampleModal" style="color: #fff;background: #2dcd89;">Nagad</a>
       
    </div>
   
    <div class="card-4">
        <a href="javascript:void(0)" data-id="2" data-resource="{&quot;id&quot;:2,&quot;name&quot;:&quot;Rocket&quot;,&quot;image&quot;:&quot;664c6f720492c1716285298.jpeg&quot;,&quot;min_limit&quot;:&quot;500.00000000&quot;,&quot;max_limit&quot;:&quot;25000.00000000&quot;,&quot;delay&quot;:&quot;Auto System&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;currency&quot;:&quot;BDT&quot;,&quot;user_data&quot;:{&quot;number&quot;:{&quot;field_name&quot;:&quot;number&quot;,&quot;field_level&quot;:&quot;Number&quot;,&quot;type&quot;:&quot;text&quot;,&quot;validation&quot;:&quot;required&quot;}},&quot;description&quot;:&quot;&lt;span style=\&quot;color: rgb(33, 37, 41);\&quot;&gt;\u0986\u09aa\u09a8\u09bf \u09af\u09c7\u0987 \u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0\u09c7 \u099f\u09be\u0995\u09be \u09a8\u09bf\u09ac\u09c7\u09a8 \u09a8\u09bf\u099a\u09c7\u09b0 \u09ab\u09be\u0981\u0995\u09be \u09ac\u0995\u09cd\u09b8\u09c7 \u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0 \u099f\u09bf \u09a6\u09bf\u09df\u09c7&amp;nbsp; , CONFIRM \u098f \u0995\u09cd\u09b2\u09bf\u0995 \u0995\u09b0\u09c1\u09a8&amp;nbsp;&lt;\/span&gt;&quot;,&quot;status&quot;:1,&quot;created_at&quot;:&quot;2022-11-15T02:52:55.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-05-21T09:54:58.000000Z&quot;}" class="btn btn-block  cmn-btn deposit" data-toggle="modal" data-target="#exampleModal" style="color: #fff;background: #2dcd89;">Rocket</a>
        
    </div>
    <div class="card-4">
        <a href="javascript:void(0)" data-id="3" data-resource="{&quot;id&quot;:3,&quot;name&quot;:&quot;Bkash&quot;,&quot;image&quot;:&quot;664c6f50419781716285264.png&quot;,&quot;min_limit&quot;:&quot;500.00000000&quot;,&quot;max_limit&quot;:&quot;25000.00000000&quot;,&quot;delay&quot;:&quot;Auto System&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;currency&quot;:&quot;Taka&quot;,&quot;user_data&quot;:{&quot;number&quot;:{&quot;field_name&quot;:&quot;number&quot;,&quot;field_level&quot;:&quot;number&quot;,&quot;type&quot;:&quot;text&quot;,&quot;validation&quot;:&quot;required&quot;}},&quot;description&quot;:&quot;\u0986\u09aa\u09a8\u09bf \u09af\u09c7\u0987 \u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0\u09c7 \u099f\u09be\u0995\u09be \u09a8\u09bf\u09ac\u09c7\u09a8 \u09a8\u09bf\u099a\u09c7\u09b0 \u09ab\u09be\u0981\u0995\u09be \u09ac\u0995\u09cd\u09b8\u09c7 \u09a8\u09be\u09ae\u09cd\u09ac\u09be\u09b0 \u099f\u09bf \u09a6\u09bf\u09df\u09c7&amp;nbsp; , CONFIRM \u098f \u0995\u09cd\u09b2\u09bf\u0995 \u0995\u09b0\u09c1\u09a8&amp;nbsp;&quot;,&quot;status&quot;:1,&quot;created_at&quot;:&quot;2022-11-20T11:09:49.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-05-21T09:54:24.000000Z&quot;}" class="btn btn-block  cmn-btn deposit" data-toggle="modal" data-target="#exampleModal" style="color: #fff;background: #2dcd89;">Bkash</a>
        
    </div>
   
</div>
<!-- ========User-Panel-Section Ends Here ========-->
<!-- Modal -->
<div class="modal fade" style="display:none" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content" style="
    margin-top: 35%;
">
            <div class="modal-content">
                <div class="modal-header">
                    <strong class="modal-title method-name" id="exampleModalLabel">Withdraw Amount</strong>
                    <a href="javascript:void(0)" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </a>
                </div>
                <form action="https://earncp.com/user/withdraw" method="post">
                    <input type="hidden" name="_token" value="yy9pvpkBVDxX8Zhl1TEHxifjwAuqvUcW5L2zwXQg">
                    <div class="modal-body">
                        <div class="form-group">
                            <input type="hidden" name="method_code" class="edit-method-code  form-control" value="">
                        </div>
                        <div class="form-group">
                            <label>Enter Amount:</label>
                            <div class="input-group">
                                <input id="amount" type="text" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="amount" placeholder="0.00" required="" value="">
                                <div class="input-group-prepend">
                                    <span class="input-group-text addon-bg">Taka</span>
                                </div>
                            </div>
                        </div>
                        <span>Limit                                            : 500
                                    - 25000 Taka</span>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Confirm</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<section class="pt-120">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="card custom--card">
                    <div class="card-body">
                            <form action="{{ route('user.withdraw.money') }}" method="post">
                                @csrf
                                <div class="form-group col-lg-12">
                                <label class="label-center text-center p-3 rounded bg-primary my-4 text-white text-bolder w-100">কোন
                                    মাধ্যমে টাকা Withdraw দিতে চান সেটি সিলেক্ট করুন *</label>
                                <div class="radio-group text-center">
                                    <label class="radio-container">
                                            <input type="radio" id="method-code" name="method_code" value="1">
                                            <span class="radio-icon"><img
                                                        src="https://theshopx.net/assets/gateways/bkash.png"
                                                        width="150px"></img></span>
                                            <span class="radio-label">বিকাশ</span>
                                        </label>
                                    <label class="radio-container">
                                            <input type="radio" id="method-code" name="method_code" value="2">
                                            <span class="radio-icon"><img
                                                        src="https://theshopx.net/assets/gateways/nagad.png"
                                                        width="150px"></img></span>
                                            <span class="radio-label">নগদ</span>
                                        </label>
                                </div>
                            </div>
                            
                                

    <script src="{{asset('assets/front/js/jquery.min.js')}}"></script>
<script src="{{asset('assets/front/js/popper.min.js')}}"></script>
     
<link rel="stylesheet" href="{{asset('assets/front/css/iziToast.min.css')}}">
<script src="{{asset('assets/front/js/iziToast.min.js')}}"></script>

    <script type="text/javascript">
        (function($, document) {
            "use strict";
            function notify(status, message) {
                iziToast[status]({
                    message: message,
                    position: "topRight"
                });
            }
        }
        )(jQuery);
    </script>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                $('.deposit').on('click', function() {
                    $(".deposit").removeClass("border-green-600");
                    $(".deposit").addClass("border-gray-300");
                    // Add the "border-green-600" class to the clicked element
                    $(this).addClass("border-green-600");

                    var result = $(this).data('resource');

                    $('.method-name').text(`Withdraw Via  ${result.name}`);

                    $('.edit-method-code').val(result.id);
                });
            });
        }
        )(jQuery);
    </script>
@endsection




@push('script')
<script type="text/javascript">
    (function ($) {
            "use strict";
            $('select[name=method_code]').change(function(){
                if(!$('select[name=method_code]').val()){
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                var resource = $('select[name=method_code] option:selected').data('resource');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);
                var rate = parseFloat(resource.rate)
                var toFixedDigit = 2;
                $('.min').text(parseFloat(resource.min_limit).toFixed(2));
                $('.max').text(parseFloat(resource.max_limit).toFixed(2));
                var amount = parseFloat($('input[name=amount]').val());
                if (!amount) {
                    amount = 0;
                }
                if(amount <= 0){
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                $('.preview-details').removeClass('d-none');

                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                $('.charge').text(charge);
                if (resource.currency != '{{ $general->cur_text }}') {
                    var rateElement = `<span>@lang('Conversion Rate')</span> <span class="fw-bold">1 {{__($general->cur_text)}} = <span class="rate">${rate}</span>  <span class="base-currency">${resource.currency}</span></span>`;
                    $('.rate-element').html(rateElement);
                    $('.rate-element').removeClass('d-none');
                    $('.in-site-cur').removeClass('d-none');
                    $('.rate-element').addClass('d-flex');
                    $('.in-site-cur').addClass('d-flex');
                }else{
                    $('.rate-element').html('')
                    $('.rate-element').addClass('d-none');
                    $('.in-site-cur').addClass('d-none');
                    $('.rate-element').removeClass('d-flex');
                    $('.in-site-cur').removeClass('d-flex');
                }
                var receivable = parseFloat((parseFloat(amount) - parseFloat(charge))).toFixed(2);
                $('.receivable').text(receivable);
                var final_amo = parseFloat(parseFloat(receivable)*rate).toFixed(toFixedDigit);
                $('.final_amo').text(final_amo);
                $('.base-currency').text(resource.currency);
                $('.method_currency').text(resource.currency);
                $('input[name=amount]').on('input');
            });
            $('input[name=amount]').on('input',function(){
                var data = $('select[name=method_code]').change();
                $('.amount').text(parseFloat($(this).val()).toFixed(2));
            });
        })(jQuery);
</script>
@endpush
