@extends($activeTemplate.'layouts.app')
@section('panel')
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
        <style>
            * {
                font-family: Kanit,cursive;
                -webkit-touch-callout: none;
                -webkit-user-select: none;
                -moz-user-select: none;
                user-select: none;
                box-sizing: border-box;
                padding: 0;
                margin: 0;
            }

            #nprogress {
                pointer-events: none;
            }

            #nprogress .bar {
                background: #B72B41;
                position: fixed;
                z-index: 9999;
                top: 0;
                left: 0;
                width: 100%;
                height: 3px;
            }

            #nprogress .peg {
                display: block;
                position: absolute;
                right: 0px;
                width: 100px;
                height: 100%;
                box-shadow: 0 0 10px #B72B41, 0 0 5px #B72B41;
                opacity: 1;
                -webkit-transform: rotate(3deg) translate(0px, -4px);
                -ms-transform: rotate(3deg) translate(0px, -4px);
                transform: rotate(3deg) translate(0px, -4px);
            }

            #nprogress .spinner {
                display: block;
                position: fixed;
                z-index: 1031;
                top: 15px;
                right: 15px;
            }

            #nprogress .spinner-icon {
                width: 18px;
                height: 18px;
                box-sizing: border-box;
                border: solid 2px transparent;
                border-top-color: #B72B41;
                border-left-color: #B72B41;
                border-radius: 50%;
                -webkit-animation: nprogresss-spinner 400ms linear infinite;
                animation: nprogress-spinner 400ms linear infinite;
            }

            .nprogress-custom-parent {
                overflow: hidden;
                position: relative;
            }

            .nprogress-custom-parent #nprogress .spinner, .nprogress-custom-parent #nprogress .bar {
                position: absolute;
            }

            @-webkit-keyframes nprogress-spinner {
                0% {
                    -webkit-transform: rotate(0deg);
                }

                100% {
                    -webkit-transform: rotate(360deg);
                }
            }

            @keyframes nprogress-spinner {
                0% {
                    transform: rotate(0deg);
                }

                100% {
                    transform: rotate(360deg);
                }
            }
        </style>
    </head>
    <body>
        <div class="min-h-screen bg-[#ebebeb] pb-10">
            <a href="{{route('user.home')}}" class="h-14 w-full bg-[#ff0000] pl-4  gap-5 shadow text-white flex items-center ">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" class="h-7 font-bold cursor-pointer w-7">
                    <path fill-rule="evenodd" d="M7.72 12.53a.75.75 0 010-1.06l7.5-7.5a.75.75 0 111.06 1.06L9.31 12l6.97 6.97a.75.75 0 11-1.06 1.06l-7.5-7.5z" clip-rule="evenodd"></path>
                </svg>
        <h2 class="text-xl text-white font-bold">Transactions </h2>
    </a>
    
    @forelse($transactions as $trx)
    <div class="bg-white m-5 rounded-lg overflow-hidden">
        <div
            class="border-b rounded-b-none border-gray-300 flex px-4 justify-between items-center gap-2 p-2 mb-2 rounded-lg">
            <div class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                    fill="currentColor" aria-hidden="true" class="h-8 text-green-600 cursor-pointer w-8 ">
                    <path fill-rule="evenodd"
                        d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25zm4.28 10.28a.75.75 0 000-1.06l-3-3a.75.75 0 10-1.06 1.06l1.72 1.72H8.25a.75.75 0 000 1.5h5.69l-1.72 1.72a.75.75 0 101.06 1.06l3-3z"
                        clip-rule="evenodd"></path>
                </svg>
                <div>
                    <h2 class="text-lg -mb-1">{{$trx->remark}}</h2>
                    <p class="text-sm text-red-700"><span class="text-black">trx :</span> {{$trx->trx}}</p>
                </div>
            </div>
            <div>
                <h3 class="text-right " style="{{$trx->trx_type =='+' ? 'color:#16A34A;' : 'color: #B9315E ;'}}"><span>{{$trx->trx_type}}</span> {{showAmount($trx->amount)}}</h3>
                <p class="text-right text-sm text-gray-700">{{Carbon\Carbon::parse($trx->created_at)->diffForhumans()}}</p>
            </div>
        </div>
    </div>
@empty
    <tr>
        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
    </tr>
@endforelse
   
        
    <div class="col-lg-12">
        {{ $transactions->links() }}    
    </div>
</div>


  
<script src="{{asset('assets/front/js/jquery.min.js')}}"></script>
<script src="{{asset('assets/front/js/popper.min.js')}}"></script>
     
<link rel="stylesheet" href="{{asset('assets/front/css/iziToast.min.css')}}">
<script src="{{asset('assets/front/js/iziToast.min.js')}}"></script>

<script type="text/javascript">
    (function($,document){
        "use strict";
                        function notify(status,message) {
            iziToast[status]({
                message: message,
                position: "topRight"
            });
        }
    })(jQuery);
</script>

@endsection
