@extends($activeTemplate.'layouts.app')
@section('panel')
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
        <style>
            * {
                font-family: Kanit,cursive;
                -webkit-touch-callout: none;
                -webkit-user-select: none;
                -moz-user-select: none;
                user-select: none;
                box-sizing: border-box;
                padding: 0;
                margin: 0;
            }

            #nprogress {
                pointer-events: none;
            }

            #nprogress .bar {
                background: #B72B41;
                position: fixed;
                z-index: 9999;
                top: 0;
                left: 0;
                width: 100%;
                height: 3px;
            }

            #nprogress .peg {
                display: block;
                position: absolute;
                right: 0px;
                width: 100px;
                height: 100%;
                box-shadow: 0 0 10px #B72B41, 0 0 5px #B72B41;
                opacity: 1;
                -webkit-transform: rotate(3deg) translate(0px, -4px);
                -ms-transform: rotate(3deg) translate(0px, -4px);
                transform: rotate(3deg) translate(0px, -4px);
            }

            #nprogress .spinner {
                display: block;
                position: fixed;
                z-index: 1031;
                top: 15px;
                right: 15px;
            }

            #nprogress .spinner-icon {
                width: 18px;
                height: 18px;
                box-sizing: border-box;
                border: solid 2px transparent;
                border-top-color: #B72B41;
                border-left-color: #B72B41;
                border-radius: 50%;
                -webkit-animation: nprogresss-spinner 400ms linear infinite;
                animation: nprogress-spinner 400ms linear infinite;
            }

            .nprogress-custom-parent {
                overflow: hidden;
                position: relative;
            }

            .nprogress-custom-parent #nprogress .spinner, .nprogress-custom-parent #nprogress .bar {
                position: absolute;
            }

            @-webkit-keyframes nprogress-spinner {
                0% {
                    -webkit-transform: rotate(0deg);
                }

                100% {
                    -webkit-transform: rotate(360deg);
                }
            }

            @keyframes nprogress-spinner {
                0% {
                    transform: rotate(0deg);
                }

                100% {
                    transform: rotate(360deg);
                }
            }
        </style>
    </head>
    <body>
        <div class="min-h-screen bg-[#ebebeb] pb-10">
            <a href="{{route('user.home')}}" class="h-14 w-full bg-[#7d0984] pl-4  gap-5 shadow text-white flex items-center ">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" class="h-7 font-bold cursor-pointer w-7">
                    <path fill-rule="evenodd" d="M7.72 12.53a.75.75 0 010-1.06l7.5-7.5a.75.75 0 111.06 1.06L9.31 12l6.97 6.97a.75.75 0 11-1.06 1.06l-7.5-7.5z" clip-rule="evenodd"></path>
                </svg>
                <h2 class="text-xl font-bold text-white">My Task </h2>
            </a>
<br>
    @forelse($ads as $ad)
            <div class="col-xl-6 col-md-6 mb-3">
                <div class="card custom--card ptc-card">
                    <div class="card-body p-4">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h2 class="mt-0">{{ __($ad->title) }}</h2>
                                <span class="fs--14px mt-2">@lang('') 
                            </div>
                            <div class="col-4 text-end">
                                <h5 class="text--base mt-0">{{ $general->cur_sym }}{{ showAmount($ad->amount) }}</h5>
                                <a href="{{ route('user.ptc.show',encrypt($ad->id.'|'.auth()->user()->id)) }}" target="_blank" class="btn fs--12px px-sm-3 px-2 py-1 btn--base mt-2">@lang('View Adds')</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @empty
        <div class="card custom--card ptc-card">
            <div class="card-body">
                <h2 class="text-center text--base">{{ __($emptyMessage) }}</h2>
            </div>
        </div>
    @endforelse
</div>
@endsection

